/*:
 * @target MZ
 * @plugindesc v1.0 画面のボケを抑制（ピクセルスケーリング＆補間OFF）
 * @author HS
 */
(() => {
  "use strict";
  const applyCrisp = () => {
    try{
      if (window.PIXI) PIXI.settings.SCALE_MODE = PIXI.SCALE_MODES.NEAREST;
      const cv = Graphics && Graphics._app && Graphics._app.view;
      if (cv && cv.style){
        cv.style["image-rendering"] = "pixelated";
        cv.style["-ms-interpolation-mode"] = "nearest-neighbor";
      }
      // 文字のにじみ対策：一段階だけ内部解像度を上げる（安全域）
      if (Graphics && Graphics._app && Graphics._app.renderer){
        const r = Graphics._app.renderer;
        const res = Math.min(window.devicePixelRatio || 1, 2); // 最大2x
        if (r.resolution !== res){ r.resolution = res; r.resize(Graphics.width, Graphics.height); }
      }
    }catch(e){ console.warn("HS_CrispCanvas:", e); }
  };
  const _boot = Scene_Boot.prototype.start;
  Scene_Boot.prototype.start = function(){ _boot.call(this); applyCrisp(); };
})();
